<?
require_once('config.php');
require_once('../Connections/digiarh.php');

// filename: upload.processor.php

// first let's set some variables

// make a note of the current working directory, relative to root.
$directory_self = str_replace(basename($_SERVER['PHP_SELF']), '', $_SERVER['PHP_SELF']);

// make a note of the directory that will recieve the uploaded files

$uploadsDirectoryAcces = $_SERVER['DOCUMENT_ROOT'] . $directory_self . '../images/upload/';
$uploadsDirectoryMaster = $_SERVER['DOCUMENT_ROOT'] . $directory_self . '../images/upload/master/';

// make a note of the location of the upload form in case we need it
//$uploadForm = 'http://' . $_SERVER['HTTP_HOST'] . $directory_self . 'insert_replica.php';
$uploadForm = 'http://' . $_SERVER['HTTP_HOST'] . $directory_self . 'imagini_metadate.php';




// make a note of the location of the success page
//$uploadSuccess = 'http://' . $_SERVER['HTTP_HOST'] . $directory_self . 'insert_replica.php';
$uploadSuccess = 'http://' . $_SERVER['HTTP_HOST'] . $directory_self . 'imagini_metadate.php';

// name of the fieldname used for the file in the HTML form
$fieldnameAcces = 'acces';
$fieldnameMaster = 'master';

// Now let's deal with the upload

// possible PHP upload errors
$errors = array(1 => 'php.ini - depasire dimensiune fisier', 
                2 => 'html form - depasire dimensiune fisier', 
                3 => 'upload partial', 
                4 => 'niciun fisier atasat');

// check the upload form was actually submitted else print form
isset($_POST['submit'])		or error('the upload form is neaded', $uploadForm);

// check for standard uploading errors
($_FILES[$fieldnameAcces]['error'] == 0)	or error($errors[$_FILES[$fieldnameAcces]['error']], $uploadForm);
($_FILES[$fieldnameMaster]['error'] == 0)	or error($errors[$_FILES[$fieldnameMaster]['error']], $uploadForm);
	
// check that the file we are working on really was an HTTP upload
@is_uploaded_file($_FILES[$fieldnameAcces]['tmp_name']) or error('not an HTTP upload', $uploadForm);
@is_uploaded_file($_FILES[$fieldnameMaster]['tmp_name']) or error('not an HTTP upload', $uploadForm);

// validation... since this is an image upload script we should run a check to make sure the upload is an image
@getimagesize($_FILES[$fieldnameAcces]['tmp_name']) or error('numai uploadul de imagini este disponibil', $uploadForm);
@getimagesize($_FILES[$fieldnameMaster]['tmp_name']) or error('numai uploadul de imagini este disponibil', $uploadForm);
	
	
	
$uploadFilenameAcces = $uploadsDirectoryAcces.$_FILES[$fieldnameAcces]['name'];
$uploadFilenameMaster = $uploadsDirectoryMaster.$_FILES[$fieldnameMaster]['name'];

$_SESSION['nume_fisier_master'] = $_FILES[$fieldnameMaster]['name'];
$_SESSION['nume_fisier_acces'] = $_FILES[$fieldnameAcces]['name'];
$_SESSION['locatie_fisier_acces'] = $uploadFilenameAcces;
$_SESSION['locatie_fisier_master'] = $uploadFilenameMaster;

// make a unique filename for the uploaded file and check it is not taken... if it is keep trying until we find a vacant one
/*$now = 33;
while(file_exists($uploadFilename = $uploadsDirectory.$now.'-'.$_FILES[$fieldname]['name']))
{
	$now++;
}
*/

// now let's move the file to its final and allocate it with the new filename
@move_uploaded_file($_FILES[$fieldnameAcces]['tmp_name'], $uploadFilenameAcces) or error('folderul destinatie nu permite uplodul de fisiere', $uploadForm);
@move_uploaded_file($_FILES[$fieldnameMaster]['tmp_name'], $uploadFilenameMaster) or error('folderul destinatie nu permite uplodul de fisiere', $uploadForm);


// If you got this far, everything has worked and the file has been successfully saved.
// We are now going to redirect the client to the success page.
header('Location: ' . $uploadSuccess);

// make an error handler which will be used if the upload fails
function error($error, $location, $seconds = 3)
{
	header("Refresh: $seconds; URL=\"$location\"");
	echo '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">'."\n\n".
	'<html lang="en">'."\n".
	'	<head>'."\n".
	'		<meta http-equiv="content-type" content="text/html; charset=utf-8">'."\n\n".
	'		<link rel="stylesheet" type="text/css" href="stylesheet.css">'."\n\n".
	'	<title>Upload error</title>'."\n\n".
	'	</head>'."\n\n".
	'	<body>'."\n\n".
	'	<div id="Upload" align="center">'."\n\n".
	'		<h1>Upload nerealizat</h1>'."\n\n".
	'		<p>EROARE LA INCARCARE'."\n\n".
	'		<br><br><span class="red">' . $error . '...</span>'."\n\n".
	'	 	<br><br>Pagina de upload se reincarca!</p>'."\n\n".
	'	 </div>'."\n\n".
	'</html>';
	exit;
} // end error handler

?>