<?php
/*
   program:      makeimg.php
   description:  creates new image by merging source image
                 with watermark and outputs it to the browser
*/

header("Content-Type: image/gif");
//(because the script outputs picture)

if (isset($_GET['transparency'])) {
	if ($_GET['transparency'] >= 0 && $_GET['transparency'] <= 100) {
		$transparency = (int) $_GET['transparency'];
	}
}
else $transparency = 20;
//$transparency = (int) $_GET['transparency'];
//source photo
$source_photo = stripslashes($_GET['photo']);
$photo = imagecreatefromjpeg($source_photo);
//watermark
$watermark = imagecreatefrompng('images/watermark.png');
$watermark_width = imagesx($watermark);
$watermark_height = imagesy($watermark);
//location of the watermark on the source image
$size = getimagesize($source_photo);
$dest_x = ($size[0] - $watermark_width) / 2;
$dest_y = ($size[1] - $watermark_height) / 2;

//make the image (merge source image with watermark)
imagecopymerge($photo, $watermark, $dest_x, $dest_y, 0, 0, $watermark_width, $watermark_height, $transparency);

//output the image
imagejpeg($photo);

//free memory
imagedestroy($photo);
imagedestroy($watermark);
?>